; === Program Details ===
Name "${APPNAME} Portable"
OutFile "..\..\..\${FILENAME}.paf.exe"
!ifdef COMMONFILESPLUGIN
	InstallDir ""
!else
	InstallDir "\${FOLDER}"
!endif
Caption "${APPNAME} Portable | PerkedleApps"
VIProductVersion "${APPVER}"
VIAddVersionKey ProductName "${APPNAME} Portable"
!ifdef COMMENTS
	VIAddVersionKey Comments "${COMMENTS}"
!endif
VIAddVersionKey CompanyName "PerkedleApps"
VIAddVersionKey LegalCopyright "PerkedleApps"
VIAddVersionKey FileDescription "${APPNAME} Portable"
VIAddVersionKey FileVersion "${APPVER}"
VIAddVersionKey ProductVersion "${VER}"
VIAddVersionKey InternalName "${APPNAME} Portable"
VIAddVersionKey LegalTrademarks "PerkedleApps is a Trademark of Azure Zanculmarktum"
VIAddVersionKey OriginalFilename "${FILENAME}.paf.exe"

; === Include ===
!include MUI.nsh
!include FileFunc.nsh
!insertmacro GetDrives
!include LogicLib.nsh
!include Include\SystemMessageBox.nsh

; === Runtime Switches ===
CRCCheck on
AutoCloseWindow true
RequestExecutionLevel user
ShowInstDetails nevershow

; === Program Icon ===
Icon "${APP}.ico"
!define MUI_ICON "${APP}.ico"

;=== Icon & Stye ===
BrandingText "PerkedleApps"

; === Pages ===
!ifdef INPUTBOX
	Page Custom InputBoxPageShow InputBoxPageLeave
!endif
!ifdef COMPONENTS | MULTILANG
	!define MUI_COMPONENTSPAGE_CHECKBITMAP Include\Check.bmp
	!define MUI_COMPONENTSPAGE_NODESC
	!insertmacro MUI_PAGE_COMPONENTS
!endif
!define MUI_DIRECTORYPAGE_VERIFYONLEAVE
!define MUI_PAGE_CUSTOMFUNCTION_LEAVE LeaveDirectory
!insertmacro MUI_PAGE_DIRECTORY
!define MUI_PAGE_CUSTOMFUNCTION_SHOW Windows7TaskbarProgress
!insertmacro MUI_PAGE_INSTFILES

; === Languages ===
!insertmacro MUI_LANGUAGE "English"

Var MAINPATH
Function .onInit
	; === Check if launcher is running ===
	FindProcDLL::FindProc "${LAUNCHER}.exe"
	${If} $R0 == 1
		${System::MessageBox} "${MB_OK}|${MB_ICONINFORMATION}" "${LAUNCHER} is running | PerkedleApps" "Please close all instances of ${LAUNCHER}.  The portable app can not be upgraded while it is running." $0
		Abort
	${EndIf}

	!ifdef INIT
		Call Init
	!endif

	!ifdef INPUTBOX
		!insertmacro INSTALLOPTIONS_EXTRACT_AS Include\InstallerForm.ini InstallerForm.ini
	!endif

	!ifdef MULTILANG
		Call MultiLang
	!endif

	; === Get PortableApps path ===
	${GetDrives} "HDD+FDD" GetDrivesCallBack
	StrCmp $MAINPATH "" +6
		!ifdef COMMONFILESPLUGIN
			StrCpy $INSTDIR "$MAINPATH"
		!else
			StrCpy $INSTDIR "$MAINPATH\${FOLDER}"
		!endif
FunctionEnd

!ifdef INPUTBOX
	Var VER
	Function InputBoxPageShow
		!insertmacro MUI_HEADER_TEXT "${APPNAME} Version Number" "Enter the Version Number"
		InstallOptions::InitDialog /NOUNLOAD "$PLUGINSDIR\InstallerForm.ini"
		InstallOptions::Show
	FunctionEnd

	Function InputBoxPageLeave
		; === Check for invalid version number ===
		ReadINIStr $VER "$PLUGINSDIR\InstallerForm.ini" "Field 3" "State"
		StrCmp $VER "" "" +2
			Abort
	FunctionEnd
!endif

Function LeaveDirectory
	; === Check for invalid destination directory ===
	GetInstDirError $0
	StrCmp $0 1 "" +2
		Abort

	; Check for Program Files:
	StrCpy $0 "$INSTDIR" 16 # X:\Program Files
	StrCpy $1 "$0" "" 3 # Program Files
	StrCmp $1 "Program Files" "" +2
		Abort
FunctionEnd

Function Windows7TaskbarProgress
	w7tbp::Start
FunctionEnd

Function GetDrivesCallBack
	; === Skip usual floppy letters ===
	StrCmp $8 "FDD" "" +7
		StrCmp $9 "A:\" "" +3
			Push $0
			Return
		StrCmp $9 "B:\" "" +3
			Push $0
			Return

	IfFileExists $9PortableApps "" +2
		StrCpy $MAINPATH $9PortableApps

	Push $0
FunctionEnd

Function AppInfo
	!ifdef APPINFO
		CreateDirectory "$INSTDIR\App\AppInfo"
		SetOutPath ""
			File "/oname=$INSTDIR\App\AppInfo\appicon.ico" "${APP}.ico"
			File "/oname=$INSTDIR\App\AppInfo\appicon_16.png" "${APP}_16.png"
			File "/oname=$INSTDIR\App\AppInfo\appicon_32.png" "${APP}_32.png"
		SetOutPath "$INSTDIR\App\AppInfo"
			File "Include\appinfo.ini"
		WriteINIStr "$INSTDIR\App\AppInfo\appinfo.ini" "Format" "Type" "PortableApps.comFormat"
		WriteINIStr "$INSTDIR\App\AppInfo\appinfo.ini" "Format" "Version" "0.0"
		WriteINIStr "$INSTDIR\App\AppInfo\appinfo.ini" "Details" "Name" "${APPNAME} Portable"
		WriteINIStr "$INSTDIR\App\AppInfo\appinfo.ini" "Details" "AppID" "${APP}Portable"
		WriteINIStr "$INSTDIR\App\AppInfo\appinfo.ini" "Details" "Publisher" "${PUBLISHER} & PerkedleApps"
		WriteINIStr "$INSTDIR\App\AppInfo\appinfo.ini" "Details" "Homepage" "${HOMEPAGE}"
		WriteINIStr "$INSTDIR\App\AppInfo\appinfo.ini" "Details" "Category" "${CATEGORY}"
		WriteINIStr "$INSTDIR\App\AppInfo\appinfo.ini" "Details" "Description" "${DESCRIPTION}"
		WriteINIStr "$INSTDIR\App\AppInfo\appinfo.ini" "Details" "Language" "${LANGUAGE}"
		WriteINIStr "$INSTDIR\App\AppInfo\appinfo.ini" "License" "Shareable" "true"
		WriteINIStr "$INSTDIR\App\AppInfo\appinfo.ini" "License" "OpenSource" "true"
		WriteINIStr "$INSTDIR\App\AppInfo\appinfo.ini" "License" "Freeware" "true"
		WriteINIStr "$INSTDIR\App\AppInfo\appinfo.ini" "License" "CommercialUse" "true"
		WriteINIStr "$INSTDIR\App\AppInfo\appinfo.ini" "Version" "PackageVersion" "${APPVER}"
		!ifndef INPUTBOX
			WriteINIStr "$INSTDIR\App\AppInfo\appinfo.ini" "Version" "DisplayVersion" "${VER}"
		!else
			WriteINIStr "$INSTDIR\App\AppInfo\appinfo.ini" "Version" "DisplayVersion" "$VER"
		!endif
		WriteINIStr "$INSTDIR\App\AppInfo\appinfo.ini" "Control" "Icons" "1"
		WriteINIStr "$INSTDIR\App\AppInfo\appinfo.ini" "Control" "Start" "${LAUNCHER}.exe"
	!endif
FunctionEnd

Function Help
	!ifdef HELP
		SetOutPath ""
			File "/oname=$INSTDIR\help.html" "${APP}.html"
		SetOutPath "$INSTDIR\Other\Help"
			File /r /x thumbs.db "Help\*.*"
		SetOutPath "$INSTDIR\Other\Help\images"
			File /r /x thumbs.db "Help\images\*.*"
	!endif
FunctionEnd

Function Source
	!ifdef SOURCE
		SetOutPath "$INSTDIR\Other\Source"
			File /r /x thumbs.db "*.*"
		SetOutPath "$INSTDIR\Other\Source\Include"
			File /r /x thumbs.db "Include\*.*"
	!endif
FunctionEnd

Function .onInstSuccess
	; === Refresh PortableApps.com Menu ===
	${GetParent} $INSTDIR $0
	IfFileExists "$0\PortableApps.com\PortableAppsPlatform.exe" "" +12
		; === Send message for the Menu to refresh ===
		FindProcDLL::FindProc "PortableAppsPlatform.exe"
		StrCmp $R0 1 "" +10
			IfFileExists "$0\PortableApps.com\PortableAppsPlatform.exe" "" +4
				StrCpy $1 "PortableApps.comPlatformWindowMessageToRefresh$0\PortableApps.com\PortableAppsPlatform.exe"
				System::Call 'user32::RegisterWindowMessage(t r1) i .r2'
				SendMessage 65535 $2 0 0 /TIMEOUT=1
			IfFileExists "$0\PortableApps.com\App\PortableAppsPlatform.exe" "" +4
				StrCpy $1 "PortableApps.comPlatformWindowMessageToRefresh$0\PortableApps.com\App\PortableAppsPlatform.exe"
				System::Call 'user32::RegisterWindowMessage(t r1) i .r2'
				SendMessage 65535 $2 0 0 /TIMEOUT=1
			Goto +4
	!ifndef COMMONFILESPLUGIN
		ExecShell "Open" "$INSTDIR" ; open installation directory when finished
	!endif
FunctionEnd

Function .onInstFailed
	RMDir $INSTDIR ; remove directory if empty
FunctionEnd
